USE [DownloadStatistics]
GO
/****** Object:  StoredProcedure [dbo].[ProcessFileDownloadData]    Script Date: 3/12/2014 3:34:02 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<Dave Hartless>
-- Create date: <07/20/2013>
-- Description:	<This SPROC will process a batch of files from the FileDownload table into the Record table>
-- =============================================
ALTER PROCEDURE [dbo].[ProcessFileDownloadData]
	-- Add the parameters for the stored procedure here
AS

declare @rowID BIGINT, @maxID bigint, @tableName varchar(25), @spName varchar(30)

BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements
	SET NOCOUNT ON
	-- to ensure a failure will not leave an open transaction
	SET XACT_ABORT ON 

		BEGIN TRY
		
		BEGIN TRANSACTION
	
			SET @tableName = 'FileDownload';
			SELECT @spName = OBJECT_NAME(@@PROCID);
			SET @rowID = (SELECT TrackedRowID FROM TableAggregateID WHERE OnTableName = @TableName and ForSproc = @spName);
			SET @maxID = (SELECT MAX(id) FROM FileDownload);
			

			-- if no last max id used found set to ZERO
			IF(@rowID IS NULL) 
				Begin
				INSERT INTO TableAggregateID(OnTableName, TrackedRowID, ForSproc)  Values(@tableName, 0,@spName);
				SET @rowID = 0;
			END
			
			IF object_id('tempdb..#tempFileDownload') is not null
			DROP TABLE #tempFileDownload
			
			CREATE TABLE #tempFileDownload (FileDownloadID int, FileID int, DateDownloaded datetime, Referrer nvarchar(4000), UserAgent nvarchar(4000), IPAddress varbinary(16));
			CREATE NONCLUSTERED INDEX IX_FileDownLoadID ON #tempFileDownload (FileDownloadID);
			
			INSERT INTO #tempFileDownload (FileDownloadID, FileID, DateDownloaded, Referrer, UserAgent, IPAddress)
				SELECT ID, ProjectFileID, DateDownloaded, Referrer, UserAgent, IPAddress
				FROM FileDownload where FileDownload.ID <= @maxID and FileDownload.ID > @rowID and Status = 1
				
			--update status of records from FileDownload Table to Processing
			UPDATE FileDownload set [status] = 2 where ID <= @maxID and FileDownload.ID > @rowID and Status = 1

			-- store last max ID that was used in last run to start from there
			UPDATE TableAggregateID SET TrackedRowID = @maxID where OnTableName = @tableName and ForSproc = @spName;
			
			/*
			-- Normailze Referrer data
			
			WITH Referrers (Referrer) AS
				(
				SELECT distinct(Referrer)
				FROM #tempFileDownload
				)
			MERGE Referrer as Target  
			USING Referrers as source
			ON (Target.Referrer = source.Referrer)
			WHEN NOT MATCHED THEN	
				INSERT (Referrer)
				VALUES (source.Referrer);
		
			-- Normailze UserAgent data
			WITH UserAgents (UserAgent) AS
				(
				SELECT distinct(UserAgent)
				FROM #tempFileDownload
				)
			MERGE UserAgent as Target  
			USING UserAgents as source
			ON (Target.UserAgent = source.UserAgent)
			WHEN NOT MATCHED THEN	
				INSERT (UserAgent)
				VALUES (source.UserAgent);
			*/

			--Insert nomailzed data into Record table
			insert into Record (FileID, [Date], IPAddress)
				select a.FileID,  a.DateDownloaded as [Date], a.IpAddress
				from #tempFileDownload a
			
			--update status of records from FileDownload Table to Processed for later delete
			Update FileDownload set [status] = 3 where ID <= @maxID and FileDownload.ID > @rowID and Status = 2
			
			--drop temp table
			drop table #tempFileDownload
			
			COMMIT TRANSACTION

		END TRY
	
	BEGIN CATCH
	    ROLLBACK TRANSACTION
	END CATCH
END

